#include "FindPixel.au3"
#include <WinAPIGdi.au3>

$hWnd = WinGetHandle("FindPixel Help (v1.4)") ;Получает дескриптор окна справки FindPixel
If @error Then
    ConsoleWrite(@CR & "An error occurred when trying to retrieve " & _
            "the window handle of FindPixel Help window." & @CR)
    Exit
EndIf

If BitAND(WinGetState($hWnd), 16) Then _
        WinSetState($hWnd, "", @SW_RESTORE) ;Разворачивает окно справки, если оно свернуто

;_FPGetSearchMode-----------------------------------------------------------------------------------
ConsoleWrite(@CR & "Search Mode: " & _FPGetSearchMode() & @CR) ;Пишет в консоль режим поиска

_FPTakeSnapshot(0, 0, 0, 0, $hWnd) ;Делает скриншот окна справки

;_FPGetImageHandle demonstration--------------------------------------------------------------------
$hBMP = _FPGetImageHandle() ;Получает дескриптор картинки в буфере
ConsoleWrite("Image in buffer handle: " & $hBMP & @CR)

$SIZE = _WinAPI_GetBitmapDimension($hBMP)
$Width = DllStructGetData($SIZE, 'X') ;Ширина картинки в буфере
$Height = DllStructGetData($SIZE, 'Y') ;Высота картинки в буфере

;_FPFindPixel demonstration-------------------------------------------------------------------------
$ImageLeftTop = _FPFindPixel(0, 0, $Width, $Height, 0x4CB122, 0, 1) ;Ищет первый пиксель в зеленой
;точке размером 4х4 пикселя, расположенной в левом верхнем углу квадрата
If $ImageLeftTop == -2 Then
    ConsoleWrite("The test image is not visible." & @CR)
    Exit
Else
    ConsoleWrite("Left top corner coordinates: " & $ImageLeftTop[0] & ", " & $ImageLeftTop[1] & @CR)
EndIf

$ImageRightBottom = _FPFindPixel(0, 0, $Width, $Height, 0xA449A3, 0, 1);Ищет первый пиксель в лиловой
;точке размером 4х4 пикселя, расположенной в правом нижнем углу квадрата
If $ImageRightBottom == -2 Then
    ConsoleWrite("The test image is not completely visible." & @CR)
    Exit
Else
    ConsoleWrite("Right bottom corner coordinates: " & $ImageRightBottom[0] + 3 & _
            ", " & $ImageRightBottom[1] + 3 & @CR)
EndIf

;_FPTakeSnapshot demonstration----------------------------------------------------------------------
_FPTakeSnapshot($ImageLeftTop[0], $ImageLeftTop[1], 251, 251, $hWnd) ;Делает скриншот квадрата и
;загружает в буфер

;_FPSaveImage demonstration-------------------------------------------------------------------------
_FPSaveImage("Test image.bmp") ;Сохраняет в файл изображение в буфере

;_FPLoadImage demonstration-------------------------------------------------------------------------
_FPLoadImage("Test image.bmp") ;Загружает в буфер сохраненное изображение с файла - тот же квадрат

;_FPFindAllPixel demonstration----------------------------------------------------------------------
$PixelNum = _FPFindAllPixel(100, 100, 100, 100, 0x241CED, 0, 1) ;Ищет все пиксели красного цвета
;внутри заданной области с координатами относительно л. в. угла квадрата, возвращает их количество

If Not @error Then _
        ConsoleWrite("There are " & $PixelNum & " pixels within the search area." & @CR)

If $PixelNum > 0 Then
    ;_FPGetAllPixelPosition demonstration-----------------------------------------------------------
    $AllPixelPosition = _FPGetAllPixelPosition($PixelNum) ;Записывает в массив положение всех точек
    ;найденных _FPFindAllPixel
    ;_FPGetPixel demonstration----------------------------------------------------------------------
    $Color = _FPGetPixel($AllPixelPosition[0][0], $AllPixelPosition[0][1]) ;Получает значение цвета
    ;первого найденного красного пикселя
    ConsoleWrite("Their color: " & $Color & @CR)

    ConsoleWrite("Their coordinates:" & @CR)
    For $i = 0 To UBound($AllPixelPosition, 1) - 1
        ConsoleWrite($AllPixelPosition[$i][0] & ", " & $AllPixelPosition[$i][1] & @CR)
    Next
EndIf

_WinAPI_DeleteObject(_FPGetImageHandle()) ;Очищает буфер